// GpPenEscC.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscC Dialog


CGpPenEscC::CGpPenEscC(CWnd* pParent /*=NULL*/)
	:CIndecateCircle(CGpPenEscC::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscC)
	m_cLineStyle = 0;
	//}}AFX_DATA_INIT

	Create(IDD,pParent);
}


void CGpPenEscC::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscC)
	DDX_CBIndex(pDX, IDC_cLineStyle, m_cLineStyle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscC, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscC)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscC Message Handler

void CGpPenEscC::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}


// Create Content
CContents*  CGpPenEscC::CreateContents()
{
	// Create empty content
	CContentsEscC* pContents = new CContentsEscC();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Line Style
	pContents->m_Data.cLineStyle = m_cLineStyle ;
	if( pContents->m_Data.cLineStyle > 3 )
	{
		pContents->m_Data.cLineStyle += 4 ;
	}


	// Set Content the display position
	pContents->m_Data.iX1         = m_iX1 ;			// Center position for circle
	pContents->m_Data.iY1         = m_iY1 ;			// Center position for circle
	pContents->m_Data.iRadius     = m_iRadius ;		// Radius for circle

	return( pContents );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Draw Circle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecateCircle::ActionErase(CDC* pDC)
{
	if( m_bAction ){
		InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
		InvertLine(pDC,m_StartPoint.x,m_StartPoint.y,m_iX1,m_iY1);
		m_bAction = FALSE ;
	}
}

// Draw to the new position
void CIndecateCircle::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	double dx,dy,dr ;

	// Erase
	ActionErase(pDC);

	// Draw at new position
	m_iX1 = NewPoint.x ;
	m_iY1 = NewPoint.y ;

	dx = m_iX1 - m_StartPoint.x ;
	dy = m_iY1 - m_StartPoint.y ;
	dr = dx * dx + dy * dy ;
	m_iRadius = (int )sqrt(dr) ;

	InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
	InvertLine(pDC,m_StartPoint.x,m_StartPoint.y,m_iX1,m_iY1);
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecateCircle::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{
	m_StartPoint = point ;
	m_iX1 = point.x ;
	m_iY1 = point.y ;

	ActionDisplay(point,pDC);
	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecateCircle::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecateCircle::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;

	return( B_ActionOk );
}

// Cancel
int  CIndecateCircle::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}
